#!/bin/sh

TP_MSG_OK_RESULT_OK="DTAS[TUI]@{OK}"
TP_MSG_OK_RESULT_CANCEL="DTAS[TUI]@{CANCEL}"
TP_MSG_OK_RESULT_ERROR="DTAS[TUI]@{ERROR}"
TP_MSG_OK_RESULT_CODE=""

TP_MSG_OK_RESULT_MSG=""

tp_msg_ok() {
	local title="${1}"
	local text="${2}"
	local ok_label="${3}"

    exec 3>&1
    local ret=`dialog \
        --backtitle "${CONS_BACK_TITLE}" \
        --title     "${title}" \
        --ok-label  "${ok_label}" \
        --msgbox    "${text}" \
                    "${CONS_BOX_HEIGHT}" \
                    "${CONS_BOX_WIDTH}" \
        2>&1 1>&3; \
        case "${?}" in \
            1|255) echo "${TP_MSG_OK_RESULT_CANCEL}" ;; \
        esac`
    exec 3>&-


    ##################################################
    # press "CANCEL" or "ESC"
    ##################################################
    case "${ret}" in
        0 | "" | "${TP_MSG_OK_RESULT_CANCEL}" )
            TP_MSG_OK_RESULT_CODE="${TP_MSG_OK_RESULT_OK}"
            TP_MSG_OK_RESULT_MSG=""
            return
            ;;
            
        * )
            TP_MSG_OK_RESULT_CODE="${TP_MSG_OK_RESULT_ERROR}"
            TP_MSG_OK_RESULT_SELECT="${TP_MSG_OK_RESULT_NULL}"
            TP_MSG_OK_RESULT_MSG="${TP_MSG_OK_ERROR_UNKNOWN_ERROR}"
            return
            ;;
    esac
}

